/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.parts;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.pseudo.PseudoIterator;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.dialogs.CertificateDetailDialog;
import de.willuhn.jameica.gui.dialogs.CertificateTrustDialog;
import de.willuhn.jameica.gui.dialogs.YesNoDialog;
import de.willuhn.jameica.gui.formatter.DateFormatter;
import de.willuhn.jameica.gui.formatter.TableFormatter;
import de.willuhn.jameica.gui.internal.action.CertificateImport;
import de.willuhn.jameica.gui.parts.CheckedContextMenuItem;
import de.willuhn.jameica.gui.parts.ContextMenu;
import de.willuhn.jameica.gui.parts.ContextMenuItem;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.parts.table.FeatureSummary;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.security.Certificate;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import javax.net.ssl.X509TrustManager;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.TableItem;

public class CertificateList
extends TablePart {
    private static final Settings mySettings = new Settings(CertificateList.class);

    public CertificateList() throws Exception {
        this(Application.getSSLFactory().getTrustManager(), true);
    }

    public CertificateList(X509TrustManager trustManager, final boolean changable) {
        super(CertificateList.init(trustManager), (Action)new Open());
        this.addColumn(Application.getI18n().tr("Ausgestellt f\u00fcr"), "name");
        this.addColumn(Application.getI18n().tr("Organisation"), "organization");
        this.addColumn(Application.getI18n().tr("OU"), "ou");
        this.addColumn(Application.getI18n().tr("Aussteller"), "issuer");
        this.addColumn(Application.getI18n().tr("G\u00fcltig von"), "datefrom", new DateFormatter());
        this.addColumn(Application.getI18n().tr("G\u00fcltig bis"), "dateto", new DateFormatter());
        this.addColumn(Application.getI18n().tr("Seriennummer"), "serial");
        this.setMulti(false);
        this.removeFeature(FeatureSummary.class);
        this.setFormatter(new TableFormatter(){

            @Override
            public void format(TableItem item) {
                if (item == null || item.getData() == null) {
                    return;
                }
                try {
                    CertObject o = (CertObject)item.getData();
                    if (Application.getSSLFactory().getSystemCertificate().equals(o.cert)) {
                        item.setForeground(Color.COMMENT.getSWTColor());
                    } else {
                        item.setForeground(Color.FOREGROUND.getSWTColor());
                    }
                }
                catch (Exception e) {
                    Logger.error((String)"unable to check for system certificate", (Throwable)e);
                }
            }
        });
        ContextMenu menu = new ContextMenu();
        menu.addItem(new CheckedContextMenuItem(Application.getI18n().tr("\u00d6ffnen..."), new Open(), "document-open.png"));
        menu.addItem(new CheckedContextMenuItem(Application.getI18n().tr("L\u00f6schen..."), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                if (context == null || !(context instanceof CertObject)) {
                    throw new ApplicationException(Application.getI18n().tr("Bitte w\u00e4hlen Sie das zu l\u00f6schende Zertifikat aus"));
                }
                X509Certificate c = ((CertObject)context).cert;
                CertificateTrustDialog d = new CertificateTrustDialog(1, c);
                d.setText(Application.getI18n().tr("Sind Sie sicher, dass Sie dieses Zertifikat aus dem Stammspeicher l\u00f6schen wollen?"));
                try {
                    Boolean b = (Boolean)d.open();
                    if (b != null && b.booleanValue()) {
                        Application.getSSLFactory().removeTrustedCertificate(c);
                        CertificateList.this.removeItem(context);
                    }
                }
                catch (OperationCanceledException oce) {
                    Logger.info((String)Application.getI18n().tr("Vorgang abgebrochen"));
                    return;
                }
                catch (Exception e) {
                    Logger.error((String)"error while deleting certificate", (Throwable)e);
                    Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Fehler beim L\u00f6schen des Zertifikats."), 1));
                }
            }
        }, "user-trash-full.png"){

            @Override
            public boolean isEnabledFor(Object o) {
                if (!changable) {
                    return false;
                }
                try {
                    if (Application.getSSLFactory().getSystemCertificate().equals(((CertObject)o).cert)) {
                        return false;
                    }
                }
                catch (Exception e) {
                    Logger.error((String)"unable to check for system certificate", (Throwable)e);
                }
                return super.isEnabledFor(o);
            }
        });
        menu.addItem(ContextMenuItem.SEPARATOR);
        menu.addItem(new CheckedContextMenuItem(Application.getI18n().tr("Exportieren..."), new Action(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleAction(Object context) throws ApplicationException {
                try {
                    X509Certificate cert = ((CertObject)context).cert;
                    Certificate myCert = new Certificate(cert);
                    String s = myCert.getSubject().getAttribute("CN");
                    String s2 = myCert.getSubject().getAttribute("OU");
                    FileDialog fd = new FileDialog(GUI.getShell(), 8192);
                    fd.setText(Application.getI18n().tr("Bitte geben Sie das Verzeichnis an, in dem Sie das Zertifikat speichern m\u00f6chten"));
                    if (s2 != null && s2.length() > 0) {
                        fd.setFileName(s + "-" + s2 + ".crt");
                    } else {
                        fd.setFileName(s + ".crt");
                    }
                    fd.setFilterPath(mySettings.getString("lastdir", System.getProperty("user.home")));
                    String target = fd.open();
                    if (target == null) {
                        return;
                    }
                    File f = new File(target);
                    if (f.exists()) {
                        YesNoDialog d = new YesNoDialog(1);
                        d.setTitle(Application.getI18n().tr("\u00dcberschreiben?"));
                        d.setText(Application.getI18n().tr("Datei existiert bereits. \u00dcberschreiben?"));
                        Boolean b = (Boolean)d.open();
                        if (!b.booleanValue()) {
                            return;
                        }
                    }
                    try (FileOutputStream os = null;){
                        os = new FileOutputStream(f);
                        ((OutputStream)os).write(cert.getEncoded());
                        os.flush();
                        mySettings.setAttribute("lastdir", f.getParent());
                        Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Zertifikate exportiert"), 0));
                    }
                }
                catch (OperationCanceledException oce) {
                    Logger.info((String)oce.getMessage());
                    return;
                }
                catch (Exception e) {
                    Logger.error((String)"unable to export certificate", (Throwable)e);
                    Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Fehler beim Export des Zertifikates"), 1));
                }
            }
        }, "document-save.png"));
        menu.addItem(new ContextMenuItem(Application.getI18n().tr("Importieren..."), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                new CertificateImport().handleAction(context);
                GUI.startView(GUI.getCurrentView().getClass(), GUI.getCurrentView().getCurrentObject());
            }
        }, "document-open.png"){

            @Override
            public boolean isEnabledFor(Object o) {
                return changable && super.isEnabledFor(o);
            }
        });
        this.setContextMenu(menu);
    }

    private static GenericIterator init(X509TrustManager trustManager) {
        try {
            X509Certificate[] list = trustManager.getAcceptedIssuers();
            ArrayList<CertObject> al = new ArrayList<CertObject>();
            for (int i = 0; i < list.length; ++i) {
                al.add(new CertObject(list[i]));
            }
            if (trustManager == Application.getSSLFactory().getTrustManager()) {
                al.add(new CertObject(Application.getSSLFactory().getSystemCertificate()));
            }
            Collections.sort(al);
            return PseudoIterator.fromArray((GenericObject[])al.toArray(new CertObject[al.size()]));
        }
        catch (Exception e) {
            Logger.error((String)"error while loading certificate list", (Throwable)e);
            try {
                return PseudoIterator.fromArray((GenericObject[])new GenericObject[0]);
            }
            catch (Exception e2) {
                Logger.error((String)"error while loading dummy list, useless", (Throwable)e2);
                return null;
            }
        }
    }

    private static class Open
    implements Action {
        private Open() {
        }

        @Override
        public void handleAction(Object context) throws ApplicationException {
            if (context == null || !(context instanceof CertObject)) {
                return;
            }
            try {
                CertObject c = (CertObject)context;
                CertificateDetailDialog d = new CertificateDetailDialog(1, c.cert);
                d.open();
            }
            catch (OperationCanceledException oce) {
                Logger.info((String)oce.getMessage());
                return;
            }
            catch (Exception e) {
                Logger.error((String)"error while displaying certificate", (Throwable)e);
            }
        }
    }

    private static class CertObject
    implements GenericObject,
    Comparable {
        private X509Certificate cert = null;
        private Certificate myCert = null;

        private CertObject(X509Certificate cert) {
            this.cert = cert;
            this.myCert = new Certificate(cert);
        }

        public Object getAttribute(String arg0) throws RemoteException {
            if ("name".equals(arg0)) {
                Object s = this.myCert.getSubject().getAttribute("CN");
                if (s == null || ((String)s).length() == 0) {
                    s = this.cert.getSubjectDN().getName();
                    if (s != null && ((String)s).length() > 40) {
                        s = ((String)s).substring(0, 39) + "...";
                    }
                    return s;
                }
                return s;
            }
            if ("issuer".equals(arg0)) {
                Object s = this.myCert.getIssuer().getAttribute("CN");
                if (s == null || ((String)s).length() == 0) {
                    s = this.myCert.getIssuer().getAttribute("O");
                }
                if ((s == null || ((String)s).length() == 0) && (s = this.cert.getIssuerDN().getName()) != null && ((String)s).length() > 40) {
                    s = ((String)s).substring(0, 39) + "...";
                }
                return s;
            }
            if ("serial".equals(arg0)) {
                return "0x" + this.cert.getSerialNumber().toString(16).toUpperCase();
            }
            if ("organization".equals(arg0)) {
                return this.myCert.getSubject().getAttribute("O");
            }
            if ("ou".equals(arg0)) {
                return this.myCert.getSubject().getAttribute("OU");
            }
            if ("datefrom".equals(arg0)) {
                return this.cert.getNotBefore();
            }
            if ("dateto".equals(arg0)) {
                return this.cert.getNotAfter();
            }
            return null;
        }

        public String[] getAttributeNames() throws RemoteException {
            return new String[]{"name", "issuer", "serial", "datefrom", "dateto", "organization", "ou"};
        }

        public String getID() throws RemoteException {
            return (String)this.getAttribute("serial") + (String)this.getAttribute("fingerprint");
        }

        public String getPrimaryAttribute() throws RemoteException {
            return "name";
        }

        public boolean equals(GenericObject arg0) throws RemoteException {
            if (arg0 == null) {
                return false;
            }
            return this.getID().equals(arg0.getID());
        }

        public int compareTo(Object o) {
            if (!(o instanceof CertObject)) {
                return -1;
            }
            try {
                CertObject other = (CertObject)o;
                String n1 = (String)this.getAttribute("name");
                String n2 = (String)other.getAttribute("name");
                return n1.compareTo(n2);
            }
            catch (Exception e) {
                Logger.error((String)"unable to compare certs", (Throwable)e);
                return 0;
            }
        }
    }
}

